/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// Tileable Cells. By David Hoskins. 2013.

#define NUM_CELLS	16.0	// Needs to be a multiple of TILES!
#define TILES 		2.0		// Normally set to 1.0 for a creating a tileable texture.

//#define SHOW_TILING			// Display yellow lines at tiling locations.
#define ANIMATE			// Basic movement using texture values.

//------------------------------------------------------------------------
vec2 Hash2(vec2 p)
{
	#ifdef ANIMATE
	
	float t = fract(iGlobalTime*.0003);
	return texture2D(iChannel0, p*vec2(.135+t, .2325-t), -100.0).xy;
	
	#else
	
	float r = 523.0*sin(dot(p, vec2(53.3158, 43.6143)));
	return vec2(fract(15.32354 * r), fract(17.25865 * r));
	
	#endif
}

//------------------------------------------------------------------------
float Cells(in vec2 p, in float numCells)
{
	p *= numCells;
	float d = 1.0e10;
	for (int xo = -1; xo <= 1; xo++)
	{
		for (int yo = -1; yo <= 1; yo++)
		{
			vec2 tp = floor(p) + vec2(xo, yo);
			tp = p - tp - Hash2(mod(tp, numCells / TILES));
			d = min(d, dot(tp, tp));
		}
	}
	return sqrt(d);
	//return 1.0 - d;// ...Bubbles.
}

//------------------------------------------------------------------------
void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	
	#ifdef ANIMATE
	float c = Cells(uv+iGlobalTime*.025, NUM_CELLS);
	#else
	float c = Cells(uv, NUM_CELLS);
	#endif

	vec3 col = vec3(c*.83, c, min(c*1.3, 1.0));
	
	#ifdef SHOW_TILING
	// Flash tile borders...
	vec2 pixel = TILES / iResolution.xy;
	uv *= TILES;

	float f = floor(mod(iGlobalTime*.5, 2.0)); 	// Flash value.
	vec2 first = step(pixel, uv) * f;		   	// Rule out first screen pixels and flash.
	uv  = step(fract(uv), pixel);				// Add one line of pixels per tile.
	col = mix(col, vec3(1.0, 1.0, 0.0), (uv.x + uv.y) * first.x * first.y); // Yellow line
	
	#endif

	gl_FragData[0] = vec4(col, 1.0);
}
